﻿# 认证和用户相关接口

/api/auth 和 /api/public/users 接口，不要求请求头带Authorization。
/api/users 接口，要求请求头带Authorization。

+ 注册新用户流程。所需权限为目前为无。
第一步：新增一个用户。
POST /api/public/users or /api/users 
<= RequestBody: User。id不填，数据库自动生成。password字段会被忽略。
=> return: User。返回新增的用户的完整对象，包含ID。
注：用户对象中不包含密码。新增用户的密码为null，不可登录。
第二步：为新用户设置密码，步骤参考“设置密码流程”中方案一。

+ 设置密码流程。
密码为加密存放在数据库中，不可查询，生成User的json对象中不包含密码。
PATCH /api/auth
<= RequestBody结构如下：
```
{
	"username": "tjuse",    //被修改的用户的用户名
	"password": "654321",   //新密码。
	"verify" : "123456"     //校验码。含义如下。
}
```

校验码verify的含义。（方案四暂未实现）
方案一（适合新用户设置初始密码）：verify为一个supercode，仅系统管理员知道，配置在application.yml中。  
方案二（系统管理员强制改用户密码时用）目前可以使用supercode，以后为加强安全，可改为系统管理员动态申请，限时使用。  
方案三（适合用户知道自己的密码，要改密码）：verify为旧密码，检验通过后设置新密码。  
方案四（适合用户忘记旧密码，要重设密码）：用户自助申请重设密码，系统发送一个校验码到注册的手机或邮箱，用户把收到的校验码填到verify字段中完成校验并设置新密码。

+ 登录流程
POST /api/auth
<= RequestBody结构如下：
```
{
	"username": "tjuse",    //用户名
	"password": "123456"   //密码
}
```
=> Return { "token": "......" }
如果校验通过，则返回一个token。今后再发出request请求时，在headers中设置Authorization值为“Bearer {token}”。

+ 更新token
PUT /api/auth
<= RequestBody 空，headers中设置Authorization值。
=> Return { "token": "......" }

+ 获得当前用户的信息
GET /api/auth
<= RequestBody 空，headers中设置Authorization值。
=> Return User 

+ 列出所有用户的信息。所需权限为系统管理员。
GET /api/users  => Return User[]

+ 按ID列出用户的详细信息。所需权限为系统管理员或ID本人。
GET /api/users/{id} => Return User 

+ 按username查找用户。无权限要求。仅返回userId（找到）或空（未找到）
GET /api/public/users/username/{username} => Ruturn number
GET /api/users/username/{username} => Ruturn number

+ 按phone查找用户。无权限要求。仅返回userId（找到）或空（未找到）
GET /api/public/users/phone/{phone} => Ruturn number
GET /api/users/phone/{phone} => Ruturn number

+ 按email查找用户。无权限要求。仅返回userId（找到）或空（未找到）
GET /api/public/users/email/{email} => Ruturn number
GET /api/users/email/{email} => Ruturn number

+ 修改用户信息。所需权限为系统管理员或ID本人。密码不会更新。
PUT /api/users/{id} 
<= RequestBody: User
=> Return User

+ 删除用户。所需权限为系统管理员或ID本人。
DELETE /api/users/{id}
=> Return User

