package cn.edu.tju.se.auth.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity(name="Auth_User")
@Inheritance(strategy = InheritanceType.JOINED) 
//@DiscriminatorColumn(name = "USER_TYPE", 
//discriminatorType =  DiscriminatorType.STRING)
//@DiscriminatorValue(value="BASE")

public class User {
	@Id	
	@GeneratedValue
	private Long id;

	//用户（登录）名
	@Column(nullable=false,unique=true)
	private String username;
	
	@JsonIgnore
    private String password;	

    //注册日期
    private Date registerDate;
    //最后登录日期
    private Date lastLoginDate;
	//最后修改密码日期
    private Date lastPasswordResetDate;
    
//    @JsonIgnore
//    private String verify;

	//账号可用？
	private boolean enables = true;
	//账号未过期？
	private boolean accountNonExpired = true;
	//密码未过期？
	private boolean credentialsNonExpired = true;
	//账号未被锁定？
	private boolean accountNonLocked = true;
	
	//真实姓名：全名
	private String name;
	
	//真实姓名：名
	private String firstname;
	//真实姓名：中间名
	private String middlename;
	//真实姓名：姓
	private String lastname;
	
	//电子邮箱
	private String email;
	//移动电话
	private String phone;
	//身份证号
	private String idnumber;	
	//性别
	private String gender;	
	//出生日期
	private Date birthday;

	@JsonIgnore
	@ManyToMany(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER)
	@JoinTable(name = "Auth_r_User_Group",
	joinColumns = {@JoinColumn(name = "User_ID", referencedColumnName = "id")},
	inverseJoinColumns = {@JoinColumn(name = "Group_ID", referencedColumnName ="id")})
	private Set<Group> groups;

	@JsonIgnore
	@ManyToMany(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER)
	@JoinTable(name = "Auth_r_User_Role",
	joinColumns = {@JoinColumn(name = "User_ID", referencedColumnName = "id")},
	inverseJoinColumns = {@JoinColumn(name = "Role_ID", referencedColumnName ="id")})
	private Set<Role> roles;

	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public boolean isEnables() {
		return enables;
	}

	public void setEnables(boolean enables) {
		this.enables = enables;
	}

	public boolean isAccountNonExpired() {
		return accountNonExpired;
	}

	public void setAccountNonExpired(boolean accountNonExpired) {
		this.accountNonExpired = accountNonExpired;
	}

	public boolean isCredentialsNonExpired() {
		return credentialsNonExpired;
	}

	public void setCredentialsNonExpired(boolean credentialsNonExpired) {
		this.credentialsNonExpired = credentialsNonExpired;
	}

	public boolean isAccountNonLocked() {
		return accountNonLocked;
	}

	public void setAccountNonLocked(boolean accountNonLocked) {
		this.accountNonLocked = accountNonLocked;
	}
	
	public String getFirstname() {
		return firstname;
	}

	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	public String getMiddlename() {
		return middlename;
	}

	public void setMiddlename(String middlename) {
		this.middlename = middlename;
	}

	public String getLastname() {
		return lastname;
	}

	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getIdnumber() {
		return idnumber;
	}

	public void setIdnumber(String idnumber) {
		this.idnumber = idnumber;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public Set<Group> getGroups() {
		return groups;
	}

	public void setGroups(Set<Group> groups) {
		this.groups = groups;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Date getLastPasswordResetDate() {
		return lastPasswordResetDate;
	}

	public void setLastPasswordResetDate(Date lastPasswordResetDate) {
		this.lastPasswordResetDate = lastPasswordResetDate;
	}

	public List<String> getRoles() {
		List<String> roles = new ArrayList<String>();
		Iterator<Role> it = this.roles.iterator();
		while(it.hasNext()) {
			roles.add(it.next().getName());
		}
		return roles;
	}

//	public Set<Role> getRoles() {
//		return roles;
//	}

	public void setRoles(Set<Role> roles) {
		this.roles = roles;
	}

	public Date getRegisterDate() {
		return registerDate;
	}

	public void setRegisterDate(Date registerDate) {
		this.registerDate = registerDate;
	}

	public Date getLastLoginDate() {
		return lastLoginDate;
	}

	public void setLastLoginDate(Date lastLoginDate) {
		this.lastLoginDate = lastLoginDate;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
    
//	public String getVerify() {
//		return verify;
//	}
//	
//	public void setVerify(String verify) {
//		this.verify = verify;
//	}

}
