import { Injectable, Inject } from '@angular/core';
import { Http, Headers, Response } from '@angular/http';

import 'rxjs/add/operator/toPromise';
import { Auth } from '../domain/auth';
import {ApiService} from './api.service';
@Injectable()
export class AuthService {

  private headers ;
  private authUrl ;

  constructor(private http: Http, private apiService: ApiService, @Inject('user') private userService) {
      this.headers = apiService.getHeaders();
      this.authUrl = apiService.getUrl() + '/auth';
  }

  loginWithCredentials1(username: string, password: string): Promise<Auth> {
    return this.userService.getUserByUsername(username)  //调用UserService中的方法来查找user
      .then(user => {
        let auth = new Auth();
        localStorage.removeItem('userId');  //首先移除当前本地存储的userId
        let redirectUrl = (localStorage.getItem('redirectUrl') === null) ?
          '/' : localStorage.getItem('redirectUrl');
        auth.redirectUrl = redirectUrl;      //存储原本要访问的Url
        if (null === user) {
          //没找到user
          auth.hasError = true;
          auth.errMsg = 'user not found';
        } else if (password === user.password) {
          //找到user并与密码匹配成功
          auth.user = Object.assign({}, user);
          auth.hasError = false;
          localStorage.setItem('userId', user.id);
        } else {
          //密码错误
          auth.hasError = true;
          auth.errMsg = 'password not match';
        }
        return auth;
      })
      .catch(this.handleError);
  }

  loginWithCredentials(credentials): Promise<Auth> {
    return this.http.post(this.authUrl, JSON.stringify(credentials), {headers: this.headers})
      .toPromise()
      .then(res => {
        sessionStorage.removeItem('token');
        let data = res.json();
        let auth = new Auth();
        let redirectUrl = (sessionStorage.getItem('redirectUrl') === null)? '/': sessionStorage.getItem('redirectUrl');
        auth.redirectUrl = redirectUrl;
        auth.hasError = false;
        sessionStorage.setItem('token', data.token);
        this.userService.whoami() 
        .then(user => {
          sessionStorage.setItem('me',user.username);
          sessionStorage.setItem('userId',user.id);
          if(user.username.indexOf("admin")!=-1){
            sessionStorage.setItem('admin','true');
          } else {
            sessionStorage.setItem('admin','false');
          }
        });
        return auth;
      })
      .catch(this.handleError);
  }
  private handleError(error: any): Promise<any> {
    console.error('An error occurred', error);
    return Promise.reject(error.message || error);
  }
}

