import { Component, OnInit } from '@angular/core';
import { Hero } from '../../domain/hero';
import { HeroService } from '../../service/hero.service';

@Component({
  selector: 'app-hero-list',
  templateUrl: './hero-list.component.html',
  styleUrls: ['./hero-list.component.css']
})
export class HeroListComponent implements OnInit {

  constructor(private heroService: HeroService) { }

  heroes : Hero[];
  selectedHero : Hero;

  ngOnInit() {
    this.heroService.getHeroes().then(heroes => this.heroes = heroes);
  }

  onSelect(hero: Hero): void {
    this.selectedHero = hero;
  }
}
