package cn.edu.tju.se.auth.domain;

import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity(name="Auth_Role")
public class Role {
	@Id
	@GeneratedValue
	private Long id;

	private String name;
	
	@JsonIgnore
	@ManyToMany(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER)
	@JoinTable(name = "Auth_r_User_Role", joinColumns = { @JoinColumn(name = "Role_ID", referencedColumnName = "id") }, inverseJoinColumns = { @JoinColumn(name = "User_ID", referencedColumnName = "id") })
	private Set<User> users;
	
	@JsonIgnore
	@ManyToMany(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER)
	@JoinTable(name = "Auth_r_Group_Role", joinColumns = { @JoinColumn(name = "Role_ID", referencedColumnName = "id") }, inverseJoinColumns = { @JoinColumn(name = "Group_ID", referencedColumnName = "id") })
	private Set<Group> groups;

	@ManyToMany(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER)
	@JoinTable(name = "Auth_r_Role_Privilege", joinColumns = { @JoinColumn(name = "Role_ID", referencedColumnName = "id") }, inverseJoinColumns = { @JoinColumn(name = "Privilege_ID", referencedColumnName = "id") })
	private Set<Privilege> privileges;


	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public Set<Group> getGroups() {
		return groups;
	}


	public void setGroups(Set<Group> groups) {
		this.groups = groups;
	}


	public Set<Privilege> getPrivileges() {
		return privileges;
	}


	public void setPrivileges(Set<Privilege> privileges) {
		this.privileges = privileges;
	}
	
}
