package cn.edu.tju.se.base.domain;

import java.io.Serializable;

import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity(name="base_address")
@Inheritance(strategy = InheritanceType.JOINED) 

//@DiscriminatorColumn(name = "ADDRESS_TYPE", 
//discriminatorType =  DiscriminatorType.STRING)
//@DiscriminatorValue(value="BASE")

public class Address implements Serializable {

	@Id
	@GeneratedValue
	private Long id;
	
	@ManyToOne
	@JoinColumn(name = "country_id")
	private Dict country;
	@ManyToOne
	@JoinColumn(name = "province_id")
	private Dict province;
	@ManyToOne
	@JoinColumn(name = "city_id")
	private Dict city;
	@ManyToOne
	@JoinColumn(name = "district_id")
	private Dict district;
	private String detail;
	
	private String street;
	private String streetNumber;
	private String unit;
	
	private String zipcode;
	
	private Double longitude;
	private Double latitude;
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getZipcode() {
		return zipcode;
	}
	public void setZipcode(String zipcode) {
		this.zipcode = zipcode;
	}

	public Dict getCountry() {
		return country;
	}
	public void setCountry(Dict country) {
		this.country = country;
	}
	public Dict getProvince() {
		return province;
	}
	public void setProvince(Dict province) {
		this.province = province;
	}
	public Dict getCity() {
		return city;
	}
	public void setCity(Dict city) {
		this.city = city;
	}

	public Double getLongitude() {
		return longitude;
	}
	public void setLongitude(Double longitude) {
		this.longitude = longitude;
	}
	public Double getLatitude() {
		return latitude;
	}
	public void setLatitude(Double latitude) {
		this.latitude = latitude;
	}
	public Dict getDistrict() {
		return district;
	}
	public void setDistrict(Dict district) {
		this.district = district;
	}
	public String getDetail() {
		return detail;
	}
	public void setDetail(String detail) {
		this.detail = detail;
	}
	public String getStreet() {
		return street;
	}
	public void setStreet(String street) {
		this.street = street;
	}
	public String getStreetNumber() {
		return streetNumber;
	}
	public void setStreetNumber(String streetNumber) {
		this.streetNumber = streetNumber;
	}
	public String getUnit() {
		return unit;
	}
	public void setUnit(String unit) {
		this.unit = unit;
	}
	
}
