package cn.edu.tju.se.auth.domain;

import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;

import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.JoinColumn;

@Entity(name="Auth_Group")
public class Group {
	@Id
	@GeneratedValue
	private Long id;

	private String name;

	@JsonIgnore
	@ManyToMany(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER)
	@JoinTable(name = "Auth_r_User_Group", joinColumns = { @JoinColumn(name = "Group_ID", referencedColumnName = "id") }, inverseJoinColumns = { @JoinColumn(name = "User_ID", referencedColumnName = "id") })
	private Set<User> users;

	@JsonIgnore
	@ManyToMany(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER)
	@JoinTable(name = "Auth_r_Group_Role", joinColumns = { @JoinColumn(name = "Group_ID", referencedColumnName = "id") }, inverseJoinColumns = { @JoinColumn(name = "Role_ID", referencedColumnName = "id") })
	private Set<Role> roles;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Set<User> getUsers() {
		return users;
	}

	public void setUsers(Set<User> users) {
		this.users = users;
	}

	public Set<Role> getRoles() {
		return roles;
	}

	public void setRoles(Set<Role> roles) {
		this.roles = roles;
	}

}
