package cn.edu.tju.se.auth.service;

import java.util.List;

import cn.edu.tju.se.auth.domain.Password;
import cn.edu.tju.se.auth.domain.User;

public interface UserService {
	/*
	 * id will be generated.
	 * password is ignored and will not be set. use resetPassword() to set password after user created.
	 */
    //User register(User userToAdd);
    
    /*
     * Return jwt token if authorized
     */
    String login(String username, String password);
    
    String refresh(String oldToken);
    
    /*
     * reset user's password by userId.
     * verify the code, then set user's password in encoded format.
     */
    void resetPassword(Password password);

    User add(User user);
    User update(User user);
    void delete(Long userId);
    
	User findByUsername(String username); 	
	User findByPhone(String phone);
	User findByEmail(String email);
	User findOne(Long id);

	List<User> findAll();

	User lock(Long id);
	
}
