package cn.edu.tju.se.auth.web;

import cn.edu.tju.se.security.JwtAuthenticationRequest;
import cn.edu.tju.se.security.JwtAuthenticationResponse;
import cn.edu.tju.se.auth.domain.Password;
import cn.edu.tju.se.auth.domain.User;
import cn.edu.tju.se.auth.service.UserService;
import cn.edu.tju.se.base.domain.ErrorCode;
import cn.edu.tju.se.base.exception.MyException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping(value="/api")
public class AuthController {
    @Value("${jwt.header}")
    private String tokenHeader;

    @Autowired
    private UserService userService;
    
    /*
     * Get the current logged in user.
     */
//    @PreAuthorize("hasRole('USER')")
	@RequestMapping(value = "/auth", method = RequestMethod.GET)
	public User getUser(Principal user) {
		return userService.findByUsername(user.getName());
	}	

    /*
     * Login process. return the jwt token
     */
    @RequestMapping(value = "/auth", method = RequestMethod.POST)
    public ResponseEntity<?> createAuthenticationToken(
            @RequestBody JwtAuthenticationRequest authenticationRequest) throws AuthenticationException{
        final String token = userService.login(authenticationRequest.getUsername(), authenticationRequest.getPassword());
        // Return the token
        return ResponseEntity.ok(new JwtAuthenticationResponse(token));
    }

    /*
     * refresh jwt token
     */
    @RequestMapping(value = "/auth", method = RequestMethod.PUT)
    public ResponseEntity<?> refreshAndGetAuthenticationToken(
            HttpServletRequest request) throws AuthenticationException{
        String token = request.getHeader(tokenHeader);
        String refreshedToken = userService.refresh(token);
        if(refreshedToken == null) {
            return ResponseEntity.badRequest().body(null);
        } else {
            return ResponseEntity.ok(new JwtAuthenticationResponse(refreshedToken));
        }
    }

    /*
     * reset password
     */
	@RequestMapping(value = "/auth", method = RequestMethod.PATCH)
	public void resetPassword(@RequestBody Password password) {
		if (password != null) {
			userService.resetPassword(password);
		}
	}
	
//	/*
//	 * Lock or unlock a user
//	 */
//    @PreAuthorize("hasRole('ADMIN')")
//    @RequestMapping(value = "/auth/{id}", method = RequestMethod.DELETE)
//    User lock(@PathVariable Long id) {
//    	return userService.lock(id);
//    }


}
