package cn.edu.tju.se.base.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import cn.edu.tju.se.base.dao.DictValueRepository;
import cn.edu.tju.se.base.domain.Dict;
import cn.edu.tju.se.base.domain.DictValue;
import cn.edu.tju.se.base.web.HttpClient;

@Service
public class ChineseAreaCodeTool {
	// HttpClient httpClient ;
	@Autowired DictService dictService;
	@Autowired DictValueRepository dictValueRepository;
	
	public void insert(){
		Dict china = new Dict();
		china.setType("country");
		List<DictValue> dictValues = new ArrayList<DictValue>();
		DictValue dictValue = new DictValue();
		dictValue.setLanguage("zh_CN");
		dictValue.setValue("中国");
		dictValues.add(dictValue);
		dictValueRepository.save(dictValues);
		china.setValues(dictValues);
		dictService.add(china);
		
		Dict shenjiTemplate = new Dict(); 
		shenjiTemplate.setType("province");
		Dict dijiTemplate = new Dict(); 
		dijiTemplate.setType("city");
		Dict xianjiTemplate = new Dict(); 
		xianjiTemplate.setType("district");
		
		// ---Getting shengji
		String shengjiJson = "http://se.tju.edu.cn/api/shengji.json";
		String json = HttpClient.doHttpGet(shengjiJson);
		//System.out.println("getResult:" + json);
		List<Dict> shengjiList = HttpClient.jsonToList(json, shenjiTemplate);

		// --- Getting diji

		String url = "http://202.108.98.30/selectJson";
		// String postJson = "{\"姓名\" : \"大憨\",\"年龄\" : 24}";
		for (int index1=0 ;index1<shengjiList.size();index1++) {
			Dict  shengji = shengjiList.get(index1);
			shengji.setParentId(china.getId());
			dictValueRepository.save(shengji.getValues());
			dictService.add(shengji);
			String requestBody = "shengji="+shengji.getValues().get(0).getValue();
			String postResult = HttpClient.doHttpPost(requestBody, url);
			List<Dict> dijiList = HttpClient.jsonToList(postResult, dijiTemplate);
			//System.out.println("==="+shengji + "=== (" + dijiList.size() +")");			
			for(int index2=0 ;index2<dijiList.size();index2++) {
				Dict diji = dijiList.get(index2);
				diji.setParentId(shengji.getId());
				dictValueRepository.save(diji.getValues());
				dictService.add(diji);
				//System.out.println(shengji + ":" + diji);
				String requestBody1 = "shengji="+shengji.getValues().get(0).getValue()
						+"&diji="+diji.getValues().get(0).getValue();
				String postResult1 = HttpClient.doHttpPost(requestBody1, url);
				List<Dict> xianjiList = HttpClient.jsonToList(postResult1, xianjiTemplate);
				//System.out.println("==="+diji + "=== (" + xianjiList.size() +")");			
				for(Dict xianji: xianjiList){
					xianji.setParentId(diji.getId());
					dictValueRepository.save(xianji.getValues());
					dictService.add(xianji);
					/*System.out.println(shengji.getValues().get(0).getValue() + ":" 
							+ diji.getValues().get(0).getValue()+":"
							+ xianji.getValues().get(0).getValue()
							+ "("+xianji.getCode()+")");*/
				}		
			}			
		}

	}
}
