package cn.edu.tju.se.base.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.edu.tju.se.base.dao.DictRepository;
import cn.edu.tju.se.base.domain.Dict;
import cn.edu.tju.se.base.service.DictService;

@Service
public class DictServiceImpl implements DictService {
	@Autowired 
	private DictRepository dictRepository;

	@Override
	public List<Dict> getByType(String type) {
		return dictRepository.findByType(type);
	}

	@Override
	public Dict get(long id) {
		// TODO Auto-generated method stub
		return dictRepository.findOne(id);
	}

	@Override
	public void add(Dict dict) {
		dictRepository.save(dict);
	}

	@Override
	public void update(Dict dict) {
		// TODO Auto-generated method stub
		dictRepository.save(dict);
	}

	@Override
	public void remove(long id) {
		// TODO Auto-generated method stub
		dictRepository.delete(id);
	}

	@Override
	public List<Dict> getAll() {
		// TODO Auto-generated method stub
		return dictRepository.findAll();
	}

	@Override
	public List<Dict> getByParentId(long parentId) {
		// TODO Auto-generated method stub
		return dictRepository.findByParentId(parentId);
	}

	@Override
	public Long getNext(Long id) {
		// TODO Auto-generated method stub
		Dict dict = dictRepository.findOne(id);
		Long next = dict.getNext();
		if (next==null){
			next=1L;
		}
		dict.setNext(next+1);
		dictRepository.save(dict);
		return next;
	}

	@Override
	public List<Dict> getByTypeAndNumber(String type, Long number) {
		// TODO Auto-generated method stub
		return dictRepository.findByTypeAndNumber(type,number);
	}

	@Override
	public List<Dict> getByName(String name) {
		// TODO Auto-generated method stub
		List<Dict> dicts = dictRepository.findByName(name);
		return dicts;
	}
	
}
