package cn.edu.tju.se.base.domain;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.edu.tju.se.base.common.CommonConstants;

@Entity(name="base_dict")
public class Dict implements Serializable {
	@Id
	@GeneratedValue
	private Long id;
	
	//词条类型：用于区分不同类别的词条。一般用于一个下拉列表中的词条类型相同。
	private String type;
	
	//词条名称：用于区分不同词条。一般用于各个全局变量。
	//与type为互斥使用。
	private String name;
	
	//词条内容。为支持多国语言，此字段为临时字段。完整数据保留在values中。
	//@Transient
	//private String value;
	//词条语言。为支持多国语言，此字段为临时字段。完整数据保留在values中。
	@Transient
	private String language;
	
	//类别内编号。往往用于同类别内多词条的排序
	private Long number;

	//代码
	private String code;
	
	//父类别编号。
	private Long parentId;
	
	//如果此词条对应自动生成编号，则prefix表示生成编号的前缀
	private String prefix;
	//如果此词条对应自动生成编号，则next表示下一个自动生成的编号
	private Long next;
	

	//支持多国语言的词条内容列表
	@OneToMany
	@JoinColumn(name = "dict_id")
	private List<DictValue> values;

	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}

	public Long getNumber() {
		return number;
	}
	public void setNumber(Long number) {
		this.number = number;
	}

	public Long getParentId() {
		return parentId;
	}
	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}
	public Long getNext() {
		return next;
	}
	public void setNext(Long next) {
		this.next = next;
	}
	public String getPrefix() {
		return prefix;
	}
	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	@Transient
	public String getValue() {
		String s = null;
		if(this.language==null){
			this.language=CommonConstants.DEFAULT_LANG;
		}
		for(int index=0;index<this.values.size();index++){
			DictValue value = this.values.get(index);
			if (value.getLanguage().equalsIgnoreCase(this.language)){
				s = value.getValue();
			}
		}	
		return s;
	}
	
	@Transient
	public void setLanguage(String lang) {
		this.language = lang;
	}
	public List<DictValue> getValues() {
		return values;
	}
	public void setValues(List<DictValue> values) {
		this.values = values;
	}

}
