package cn.edu.tju.se.base.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.edu.tju.se.base.domain.Dict;
import cn.edu.tju.se.base.domain.DictValue;
import cn.edu.tju.se.base.exception.MyException;
import cn.edu.tju.se.base.service.DictService;

@Controller
@RequestMapping(value="/api")
public class DictController {
	@Autowired
	private DictService dictService;
	
	private final String DEFAULT_LANG = "zh-cn";

	@RequestMapping(method=RequestMethod.GET,value={"/dicts","/public/dicts"})
	public @ResponseBody List<Dict> getDicts(
			//@RequestHeader("Accept-languague") String lang,  
			@RequestParam(value="lang", required=false) String lang,
			@RequestParam(value="type", required=false) String type,
			@RequestParam(value="number", required=false) Long number,
			@RequestParam(value="parent", required=false) Long parent,
			@RequestParam(value="name", required=false) String name){		
		List<Dict> dicts = null;
		if (type!=null) {
			if (number==null){
				dicts = dictService.getByType(type);
			} else {
				dicts = dictService.getByTypeAndNumber(type,number);
			}
		} else if (parent!=null){
			dicts = dictService.getByParentId(parent);
		} else if (name!=null){
			dicts = dictService.getByName(name);
		} else {
			throw new MyException(1L);
			//dicts = dictService.getAll();
		}
		this.setLanguage(dicts, lang);
		return dicts;
	}
	
	@RequestMapping(method=RequestMethod.GET, value="/public/dicts/{id}")
	public @ResponseBody Dict get(@PathVariable String id,
			@RequestParam(value="lang", required=false) String lang){		
		Dict dict =  dictService.get(Long.parseLong(id));
		this.setLanguage(dict, lang);
		return dict;
	}

	@RequestMapping(method=RequestMethod.POST,value="/public/dicts")
	@ResponseStatus(HttpStatus.OK)
	public void addByPost(@RequestBody Dict dict){
		dictService.add(dict);
	}
	
	@RequestMapping(method=RequestMethod.PUT,value="/public/dicts")
	@ResponseStatus(HttpStatus.OK)
	public void addByPut(@RequestBody Dict dict){
		dictService.add(dict);
	}
	
	@RequestMapping(method=RequestMethod.POST, value="/public/dicts/{id}")
	@ResponseStatus(HttpStatus.OK)
	public void updateByPost(@RequestBody Dict dict){
		dictService.update(dict);
	}
	
	@RequestMapping(method=RequestMethod.PUT, value="/public/dicts/{id}")
	@ResponseStatus(HttpStatus.OK)
	public void updateByPut(@RequestBody Dict dict){
		dictService.update(dict);
	}
	
	@RequestMapping(method=RequestMethod.DELETE, value="/public/dicts/{id}")
	@ResponseStatus(HttpStatus.OK)
	public void delete(@PathVariable String id){
		dictService.remove(Long.parseLong(id));
	}

	@Deprecated
	@RequestMapping(method=RequestMethod.GET,value="/type/{type}")
	public @ResponseBody List<Dict> getByType(@PathVariable String type, 
			@RequestParam(value="lang", required=false) String lang){
		List<Dict> dicts = dictService.getByType(type);
		this.setLanguage(dicts, lang);
		return dicts;
	}

	@Deprecated
	@RequestMapping(method=RequestMethod.GET,value="/parent/{parentId}")
	public @ResponseBody List<Dict> getByParent(@PathVariable String parentId,
			@RequestParam(value="lang", required=false) String lang){
		List<Dict> dicts = dictService.getByParentId(Long.parseLong(parentId));
		this.setLanguage(dicts, lang);
		return dicts;
	}

	@RequestMapping(method=RequestMethod.GET,value="/name/{name}")
	public @ResponseBody List<Dict> getByName(@PathVariable String name,
			@RequestParam(value="lang", required=false) String lang){
		List<Dict> dicts = null;//dictService.getByName(name);
		this.setLanguage(dicts, lang);
		return dicts;
	}

	private void setLanguage(Dict dict, String lang){
		if  (lang!=null){
			dict.setLanguage(lang);
		}
	}
	private void setLanguage(List<Dict> dicts, String lang){
		for(Dict dict : dicts){
			this.setLanguage(dict, lang);
		}
	}
}
