package cn.edu.tju.se.hero.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.edu.tju.se.hero.dao.HeroRepository;
import cn.edu.tju.se.hero.domain.Hero;
import cn.edu.tju.se.hero.service.HeroService;

@Service
public class HeroServiceImpl implements HeroService {

	@Autowired HeroRepository heroRepository;
	
	@Override
	public Hero get(Long id) {
		return heroRepository.findOne(id);
	}

	@Override
	public Hero update(Hero hero) {
		return heroRepository.save(hero);
	}

	@Override
	public Hero add(Hero hero) {
		return heroRepository.save(hero);
	}

	@Override
	public void remove(Long id) {
		heroRepository.delete(id);
	}

//	@Override
//	public List<Hero> getByUsername(String username) {
//		List<Hero> heros = new ArrayList<Hero>();
//		/*Iterator<Hero> it = heroRepository.findByUserUsername(username).iterator();
//		while(it.hasNext()){
//			heros.add(it.next());
//		}*/
//		return heros;
//	}

//	@Override
//	public List<Hero> getByUserId(Long userId) {
//		List<Hero> heros = new ArrayList<Hero>();
//		Iterator<Hero> it = heroRepository.findByUserId(userId).iterator();
//		while(it.hasNext()){
//			heros.add(it.next());
//		}
//		return heros;
//	}

	@Override
	public List<Hero> getAll() {
		return heroRepository.findAll();
	}

	@Override
	public List<Hero> getByOwnerId(Long ownerId) {
		return heroRepository.findByOwnerId(ownerId);
	}
	
}
