//import angular core
import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { Location } from '@angular/common';

//import third package
import 'rxjs/add/operator/switchMap';

//import service
import { HeroService } from '../../service/hero.service';

//import class
import { Hero } from '../../domain/hero';

@Component({
  selector: 'app-my-hero-detail',
  templateUrl: './my-hero-detail.component.html',
  styleUrls: ['./my-hero-detail.component.css'],
  providers: [HeroService]
})
export class MyHeroDetailComponent implements OnInit {

  hero: Hero;
  heroGenders: string[] = ['MALE', 'FEMALE', 'OTHER'];
  
  constructor(
    private route: ActivatedRoute,
    private router: Router,
    private heroService: HeroService,
    private location: Location) { }

  ngOnInit(): void {
    this.route.params
      .switchMap((params: Params) => this.heroService.getHeroById(+params['id']))
      .subscribe(hero => this.hero = hero);
  }

  save(): void {
    this.heroService.updateHero(this.hero)
      .then(() => this.goBack());
  }

  goBack(): void {
    this.location.back();
  }
}

