import { Injectable, Inject } from '@angular/core';
import { CanActivate, Router, ActivatedRouteSnapshot, RouterStateSnapshot } from '@angular/router';

@Injectable()
export class AuthGuardService implements CanActivate {

  constructor(private router: Router) { }

  canActivate(route: ActivatedRouteSnapshot, state: RouterStateSnapshot): boolean {
    let url: string = state.url;
    return this.checkLogin(url);
  }
  checkLogin(url: string): boolean {
    //已登录
    if (sessionStorage.getItem('token') !== null) { 
      if (url.indexOf("admin")==-1) {
      //返回true，放行
        return true;
      } else {
        let admin = sessionStorage.getItem("admin");
        if (admin!=null && admin=="true"){
          return true;
        } else {
          return false;
        }
      }
    //未登录
    } else {
      //首先将要访问的URL暂存
      // Store the attempted URL for redirecting
      sessionStorage.setItem('redirectUrl', url);    
      // Navigate to the login page with extras
      //然后导航到登录页面
      this.router.navigate(['/login']);
      //返回false，取消本次导航
      return false;      
    }
  }
}
