//import angular core
import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
//import my components
import { HeroesComponent }      from './heroes.component';
import { HeroListComponent }      from './hero-list/hero-list.component';
import { HeroDetailComponent }  from './hero-detail/hero-detail.component';
import { MyHeroListComponent } from './my-hero-list/my-hero-list.component';
import { MyHeroDetailComponent} from './my-hero-detail/my-hero-detail.component';

const routes: Routes = [
    {
        path: '',
        component: HeroesComponent,
        children: [
            { 
                path: '', 
                component: HeroListComponent 
            },
            {   path: 'hero/:id', 
                component: HeroDetailComponent 
            },
            {
                path:'myheroes',
                component: MyHeroListComponent
            },
            {
                path:'myhero/:id',
                component: MyHeroDetailComponent
            }
        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})

export class HeroesRoutingModule { }

